/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.vseclogs;

import com.ibm.hwmca.base.util.BaseTextBundle;
import com.ibm.hwmca.base.vseclogs.E4LogsInterface;
import com.ibm.hwmca.fw.tasklet.PanelBean;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.util.DateTimePattern;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.ui.framework.Capabilities;
import com.ibm.ui.framework.ColumnDescriptor;
import com.ibm.ui.framework.DataBean;
import com.ibm.ui.framework.IllegalUserDataException;
import com.ibm.ui.framework.ItemDescriptor;
import com.ibm.ui.framework.TaskActionEvent;
import java.text.DateFormat;
import java.util.Locale;

public class ViewSecurityLogsBean
extends PanelBean
implements DataBean {
    private static final String TRACE_MASKT = "VE4LB  T";
    private static final String TRACE_MASKF = "VE4LB  F";
    private static final String TRACE_MASKD = "VE4LB  D";
    E4LogsInterface e4Data = null;
    private String panelName = null;
    private ItemDescriptor[] m_idSecurityLogTable;
    private ColumnDescriptor[] m_cdSecurityLogTableStructure;
    private int[] m_iSecurityLogTableSelection;
    private String m_sFileStatOutput;
    static int SLT_COL_DATE = 0;
    static int SLT_COL_TIME = 1;
    static int SLT_COL_E4EVENT = 2;
    static int SLT_NUM_COLS = 3;

    public void setE4data(E4LogsInterface _e4Data) {
        Trace.trace(TRACE_MASKD, "<> setE4data");
        this.e4Data = _e4Data;
    }

    public void setPanelName(String s) {
        this.panelName = s;
    }

    public ColumnDescriptor[] getSecurityLogTableRowStructure() {
        return this.m_cdSecurityLogTableStructure;
    }

    public int getSecurityLogTableRowStatus() {
        return 3;
    }

    public int getSecurityLogTableRowCount() {
        return this.m_idSecurityLogTable.length / SLT_NUM_COLS;
    }

    public ItemDescriptor[] getSecurityLogTableRowAt(int index) {
        ItemDescriptor[] rowAt = new ItemDescriptor[SLT_NUM_COLS];
        int i = 0;
        while (i < SLT_NUM_COLS) {
            rowAt[i] = this.m_idSecurityLogTable[index * SLT_NUM_COLS + i];
            ++i;
        }
        return rowAt;
    }

    public void setSecurityLogTableRowAt(int index, ItemDescriptor[] items) throws IllegalUserDataException {
        int i = 0;
        while (i < items.length) {
            this.m_idSecurityLogTable[index * ViewSecurityLogsBean.SLT_NUM_COLS + i] = items[i];
            ++i;
        }
    }

    public int[] getSecurityLogTableSelection() {
        return this.m_iSecurityLogTableSelection;
    }

    public void setSecurityLogTableSelection(int[] selected) throws IllegalUserDataException {
        this.m_iSecurityLogTableSelection = selected;
        if (selected.length == 0) {
            Trace.trace(TRACE_MASKD, "<> setSecurityLogTableSelection: deselect");
            this.userTaskManager.setEnabled("SearchByMenu.ByEventMENUITEM", false);
        } else {
            Trace.trace(TRACE_MASKD, "<> setSecurityLogTableSelection: item " + selected[0]);
            this.userTaskManager.setEnabled("SearchByMenu.ByEventMENUITEM", this.e4Data.cfgLoaded);
        }
        if (this.e4Data != null) {
            this.e4Data.index = selected == null || selected.length == 0 ? -1 : selected[0];
        }
    }

    public String getFileStatOutput() {
        return this.m_sFileStatOutput;
    }

    public void setFileStatOutput(String s) throws IllegalUserDataException {
        this.m_sFileStatOutput = s;
    }

    public Capabilities getCapabilities() {
        return null;
    }

    public void verifyChanges() throws IllegalUserDataException {
    }

    public void save() {
    }

    public void load() {
        Trace.trace(TRACE_MASKD, "<> load");
        this.m_idSecurityLogTable = new ItemDescriptor[0];
        this.m_cdSecurityLogTableStructure = new ColumnDescriptor[0];
        this.m_iSecurityLogTableSelection = new int[0];
        this.m_sFileStatOutput = "";
    }

    public void panelAction(TaskActionEvent event) {
        Trace.trace(TRACE_MASKT, "-> panelAction(" + event + ")");
        if (event.getActionCommand().equals("CANCEL") || event.getActionCommand().endsWith("CancelButton") || event.getActionCommand().endsWith("ExitItem")) {
            this.dispose();
        } else {
            String eventText;
            if (event.getActionCommand().endsWith("DetailsItem") && !(eventText = this.m_idSecurityLogTable[this.e4Data.index * SLT_NUM_COLS + SLT_COL_E4EVENT].getTitle()).startsWith("*")) {
                Trace.trace(TRACE_MASKT, "<- panelAction(): no details");
                return;
            }
            this.userTaskManager.setEnabled("OpenSecurityLogMenu.OpenSecurityLogItem", false);
            this.userTaskManager.setEnabled("SearchByMenu.ByDateMENUITEM", false);
            this.userTaskManager.setEnabled("SearchByMenu.ByEventMENUITEM", false);
            this.userTaskManager.setEnabled("SecurityLogTable", false);
            this.userTaskManager.setEnabled("ShowEarlierEventsButton", false);
            this.userTaskManager.setEnabled("ShowLaterEventsButton", false);
            PanelTaskletRequest request = new PanelTaskletRequest();
            request.setData("source", this.panelName);
            request.setData("event", event);
            request.setData("command", event.getActionCommand());
            request.setData("e4data", this.e4Data);
            Trace.trace(TRACE_MASKT, "posting TaskletRequest");
            this.postTaskletRequest(request);
        }
        Trace.trace(TRACE_MASKT, "<- panelAction()");
    }

    public void prepare() {
        Trace.trace(TRACE_MASKD, "<> prepare");
        this.updatePanel(true);
    }

    public void update(Object updateData) {
        Trace.trace(TRACE_MASKD, "--> update");
        if (updateData != null) {
            this.setE4data((E4LogsInterface)updateData);
        }
        this.updatePanel(updateData != null);
        this.userTaskManager.refreshAllElements();
        Trace.trace(TRACE_MASKD, "<-- update");
    }

    private void updatePanel(boolean newLogs) {
        Trace.trace(TRACE_MASKD, "--> updatePanel");
        if (newLogs) {
            this.m_idSecurityLogTable = new ItemDescriptor[this.e4Data.numLogs * SLT_NUM_COLS];
            DateFormat df = DateFormat.getDateInstance(3);
            DateFormat tf = DateTimePattern.getTimeWithMillisecondsPattern(Locale.getDefault());
            int i = 0;
            while (i < this.e4Data.numLogs) {
                this.m_idSecurityLogTable[i * ViewSecurityLogsBean.SLT_NUM_COLS + 0] = new ItemDescriptor("DATE " + i, df.format(this.e4Data.logTimestampList[i]));
                this.m_idSecurityLogTable[i * ViewSecurityLogsBean.SLT_NUM_COLS + 1] = new ItemDescriptor("TIME " + i, tf.format(this.e4Data.logTimestampList[i]));
                this.m_idSecurityLogTable[i * ViewSecurityLogsBean.SLT_NUM_COLS + 2] = new ItemDescriptor("EVENT " + i, this.e4Data.logTextList[i]);
                ++i;
            }
            int[] selIdx = new int[]{0};
            this.setSecurityLogTableSelection(selIdx);
            Object[] subst = new Short[]{new Short(this.e4Data.percentFull)};
            this.setFileStatOutput(new LocalizableText(BaseTextBundle.getBundleName(), "e4.percent.full.text", subst).toString());
        }
        this.userTaskManager.setEnabled("ShowEarlierEventsButton", true);
        this.userTaskManager.setEnabled("ShowLaterEventsButton", true);
        if ((this.e4Data.eofFlag & 1) == 1) {
            this.userTaskManager.setEnabled("ShowEarlierEventsButton", false);
        }
        if ((this.e4Data.eofFlag & 2) == 2) {
            this.userTaskManager.setEnabled("ShowLaterEventsButton", false);
        }
        this.userTaskManager.setEnabled("OpenSecurityLogMenu.OpenSecurityLogItem", true);
        this.userTaskManager.setEnabled("SearchByMenu.ByDateMENUITEM", true);
        this.userTaskManager.setEnabled("SearchByMenu.ByEventMENUITEM", this.e4Data.cfgLoaded);
        this.userTaskManager.setEnabled("SecurityLogTable", true);
        Trace.trace(TRACE_MASKD, "<-- updatePanel");
    }
}

